% Read EXCEL input: share; eps_target; eps_calib; eta_target; eta_calib
data = xlsread('.\input\elastheta.xlsx','8x8','B3:F10');

%{
Setting: 1r8s2f					
    share	eps_target	eps_calib	eta_target	eta_calib
s01	3.35%	-0.1942	-0.2313	0.5387	0.5387
s02	2.28%	-0.4878	-0.5241	0.8120	0.8120
s03	9.40%	-0.5301	-0.5728	0.8221	0.8221
s04	9.78%	-0.6657	-0.7087	1.0046	1.0045
s05	4.36%	-0.7219	-0.7599	1.0329	1.0329
s06	7.05%	-0.6971	-0.7374	1.0368	1.0368
s07	24.21%	-0.7411	-0.7280	1.0434	1.0490
s08	39.55%	-0.7800	-0.5563	1.0543	1.0509

%}

% Declare dimension
n = 8;

% Check Engel's aggregation (variable engel = 1 must hold)
eta_target = data(1:n, 4:4);
theta = data(1:n, 1:1);
engel = theta'*eta_target;

% Create a diagonal matrix with diagonal terms being the own-price AUES elasticities
eps_target = data(1:n, 2:2);
theta_diag = diag(theta);
aues_diag = diag(inv(theta_diag)*eps_target);

% Initialize the determinants for checking ND (sa stores values of various
% determinants)
sa = zeros(n,1);
for i = 1:n-1
    sa(i) = (-1)^(i+1);
end

%while sa(i)*(-1)^(i+1)>0
while sa(1)>0|sa(2)<0|sa(3)>0|sa(4)<0|sa(5)>0|sa(6)<0|sa(7)>0|...
        abs(sa(8))>0.00000001
%while sa(1)>0|sa(2)<0|sa(3)>0|sa(4)<0

% Empty aues from the previous run    
aues_off = zeros(n,n);        

% For each row create random variables no larger than the |diagonal term|/n
for i = 1:n-3
    offi = (-1+2*rand)*abs(aues_diag(i,i))/n;
    for j = i+1:n-1
%        aues_off(i,j) = (-1+2*rand)*abs(aues_diag(i,i))/n;
         aues_off(i,j) = offi;
         aues_off(j,i) = aues_off(i,j);
    end
end

aues = aues_diag + aues_off;

% Create the "A" (LHS coefficient) matrix for solving the unknowns
A = zeros(n,n);
for i = 1:n-1
    A(i,i) = theta(n,1);
    A(n,i) = theta(i,1);
end
A(n-2,n) = theta(n-1,1);
A(n-1,n) = theta(n-2,1);

% This incomplete aues matrix is suitable for finding "C" (RHS coefficient) matrix 
C = -aues*theta;

% The unknowns are in "B" and are solved by A*B = C
B = inv(A)*C;

% Assign "B" to uknowns in aues, and now all aues unknows are found
for i = 1:n-1
    aues(i,n) = B(i,1);
end
aues(n-2,n-1) = B(n,1);

% Assign the solved AUES unknows (i,j) to their corresponding (j,i) elements 
for i = 1:n
    for j= 1:n
aues(j,i) = aues(i,j);
    end
end

% Check Cournot aggregation
cournot = aues*theta;

% Check NSD
for i = 1:n
sa(i) = det(aues(1:i, 1:i)/10);
end

end